<?php
include "session.php";
$pagename = "Movies";
include "header.php";
include "config.php";
?>
<body oncontextmenu="return false;">
<style>
    :root {
        --primary: #00eaff;
        --primary-glow: rgba(0, 234, 255, 0.3);
        --bg-dark: #060709;
        --card-bg: rgba(255, 255, 255, 0.04);
        --glass: rgba(20, 25, 35, 0.85);
        --radius: 12px;
    }

    body {
        margin: 0; padding: 0;
        background-color: var(--bg-dark);
        color: #f0f0f0;
        font-family: 'Montserrat', sans-serif;
        -webkit-user-select: none; user-select: none;
        overflow-x: hidden;
    }

    .content-container {
        width: 100%; max-width: 1400px;
        margin: 0 auto; padding: 15px;
        box-sizing: border-box;
    }

    /* Cabeçalho */
    .header-section {
        display: flex; align-items: center; justify-content: space-between;
        padding: 12px 20px;
        background: var(--glass);
        backdrop-filter: blur(10px);
        border-radius: var(--radius);
        margin-bottom: 20px;
        border: 1px solid rgba(255,255,255,0.08);
        box-shadow: 0 8px 32px rgba(0,0,0,0.5);
    }

    .heading { 
        font-size: 1.1rem; font-weight: 800; margin: 0; 
        text-transform: uppercase; letter-spacing: 1.5px;
        background: linear-gradient(to right, #fff, var(--primary));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    /* BARRA DE SELEÇÃO E FILTROS */
    .filter-bar {
        display: grid;
        grid-template-columns: 1.5fr 1fr;
        gap: 12px;
        margin-bottom: 25px;
    }

    .select-box {
        position: relative;
        display: flex;
        flex-direction: column;
        gap: 6px;
    }

    .select-box label {
        font-size: 0.65rem;
        color: #666;
        font-weight: 700;
        text-transform: uppercase;
        margin-left: 5px;
    }

    /* Estilização do Select */
    .custom-dropdown {
        width: 100%;
        padding: 12px 15px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 10px;
        color: #fff;
        font-size: 0.85rem;
        font-weight: 600;
        outline: none;
        cursor: pointer;
        transition: all 0.3s ease;
        appearance: none; /* Remove seta padrão */
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%2300eaff' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: calc(100% - 15px) center;
    }

    .custom-dropdown:focus {
        border-color: var(--primary);
        box-shadow: 0 0 10px var(--primary-glow);
        background-color: rgba(20, 25, 35, 0.95);
    }

    .custom-dropdown option {
        background-color: #0d1117;
        color: #fff;
    }

    /* Grid de Filmes */
    .movie-list {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(140px, 1fr));
        gap: 16px;
        list-style: none; padding: 0;
    }

    .movie-item {
        background: var(--card-bg);
        border-radius: var(--radius);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        border: 1px solid rgba(255,255,255,0.05);
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }

    .movie-item:hover {
        transform: translateY(-8px);
        border-color: var(--primary);
        box-shadow: 0 12px 24px rgba(0, 234, 255, 0.2);
    }

    .movie-poster {
        width: 100%;
        aspect-ratio: 2 / 3;
        object-fit: cover;
        transition: transform 0.5s ease;
        display: block;
    }

    .movie-item:hover .movie-poster { transform: scale(1.1); }

    .movie-info-overlay {
        padding: 12px 8px;
        background: linear-gradient(to top, rgba(0,0,0,0.95), transparent);
        position: absolute; bottom: 0; width: 100%;
    }

    .movie-title {
        margin: 0; font-size: 0.75rem; font-weight: 600; text-align: center;
        white-space: nowrap; overflow: hidden; text-overflow: ellipsis; color: #fff;
    }

    @media (max-width: 480px) {
        .movie-list { grid-template-columns: repeat(3, 1fr); gap: 10px; }
        .filter-bar { grid-template-columns: 1fr 1fr; }
        .heading { font-size: 0.9rem; }
    }

    .movie-poster { filter: blur(10px); background: #1a1a1a; transition: filter 0.3s ease; }
    .movie-poster.loaded { filter: blur(0); }
</style>

<?php
// Funções de API Inalteradas
function getApiData($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true) ?: [];
}

$order = $_GET['order'] ?? 'default';
$category_id = $_GET['id'] ?? null;
$categories_api = getApiData($get_dns . "/player_api.php?username=$username&password=$password&action=get_vod_categories");

$category_name = "Filmes";
if ($category_id && $category_id !== 'recently_added') {
    foreach ($categories_api as $cat) {
        if ($cat['category_id'] == $category_id) { $category_name = $cat['category_name']; break; }
    }
} elseif ($category_id === 'recently_added') { $category_name = "Lançamentos"; }

$url = ($category_id === 'recently_added') 
    ? $get_dns . "/player_api.php?username=$username&password=$password&action=get_vod_streams&limit=30"
    : $get_dns . "/player_api.php?username=$username&password=$password&action=get_vod_streams" . ($category_id ? "&category_id=$category_id" : "");

$movie_api = getApiData($url);

if ($order == 'recent') {
    usort($movie_api, function($a, $b) { return strtotime($b['added'] ?? 0) - strtotime($a['added'] ?? 0); });
} elseif ($order == 'az') {
    usort($movie_api, function($a, $b) { return strcmp($a['name'], $b['name']); });
}
?>

<div class="content-container">
    <header class="header-section">
        <h1 class="heading"><?= htmlspecialchars($category_name) ?></h1>
        <img src="img/sTREAMING (3) (1).png" alt="Logo" style="height: 30px; filter: drop-shadow(0 0 5px var(--primary-glow));">
    </header>

    <div class="filter-bar">
        <div class="select-box">
            <label>Gênero de Filme</label>
            <select class="custom-dropdown" id="category-select" onchange="navigate()">
                <option value="recently_added" <?= ($category_id === 'recently_added' || !$category_id) ? 'selected' : '' ?>>🚀 Lançamentos</option>
                <?php foreach ($categories_api as $cat): ?>
                    <option value="<?= $cat['category_id'] ?>" <?= $category_id == $cat['category_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat['category_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="select-box">
            <label>Ordenar Por</label>
            <select class="custom-dropdown" id="order-select" onchange="navigate()">
                <option value="default" <?= $order == 'default' ? 'selected' : '' ?>>Padrão</option>
                <option value="recent" <?= $order == 'recent' ? 'selected' : '' ?>>Novidades</option>
                <option value="az" <?= $order == 'az' ? 'selected' : '' ?>>A-Z</option>
            </select>
        </div>
    </div>

    <main class="movie-list">
        <?php if (!empty($movie_api)): foreach ($movie_api as $movie): 
            $poster = !empty($movie["stream_icon"]) ? $movie["stream_icon"] : "https://i.imgur.com/Mn7aXQD.jpg";
        ?>
            <div class="movie-item" onclick="location.href='Movie_description.php?id=<?= $movie['stream_id'] ?>'">
                <img class="movie-poster" src="<?= htmlspecialchars($poster) ?>" loading="lazy" onload="this.classList.add('loaded')">
                <div class="movie-info-overlay">
                    <p class="movie-title"><?= htmlspecialchars($movie['name']) ?></p>
                </div>
            </div>
        <?php endforeach; else: ?>
            <div style="grid-column: 1/-1; text-align: center; padding: 100px 20px; opacity: 0.5;">Nenhum conteúdo encontrado.</div>
        <?php endif; ?>
    </main>
</div>

<script>
    function navigate() {
        const id = document.getElementById('category-select').value;
        const order = document.getElementById('order-select').value;
        window.location.href = `?id=${id}&order=${order}`;
    }

    document.addEventListener('DOMContentLoaded', () => {
        // Fallback para imagens já carregadas via cache
        const images = document.querySelectorAll('.movie-poster');
        images.forEach(img => {
            if (img.complete) img.classList.add('loaded');
        });
    });
</script>
</body>